﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace YumeNikkiRandomizer
{
    class Event : RPGByteData
    {
        public int eventNum = 0;
        string eventName = ""; // 01
        public int eventX = 0; // 02
        public int eventY = 0; // 03
        List<Page> pages; // 05
        
        static string myClass = "Event";
        Chunks chunks;
        
        public Event(FileStream f)
        {
            load(f);
        }
        public Event(int num, string name, int x, int y, int pageCount = 1)
        {
            eventNum = num;
            chunks = new Chunks();
            
            eventName = name;
            eventX = x;
            eventY = y;
            chunks.add(0x01); // eventName
            chunks.add(0x02); // eventX
            chunks.add(0x03); // eventY
            
            pages = new List<Page>();
            for (int i = 0; i < pageCount; i++)
                addPage();
            chunks.add(0x05); // pages
        }
        public Event()
        {
        }
        
        // Loads a single event within a map.
        override public void load(FileStream f)
        {
            chunks = new Chunks(f, myClass);
            
            eventNum = M.readMultibyte(f);
            
            if (chunks.next(0x01))
                eventName = M.readString(f, M.S_UNTRANSLATED);
            
            if (chunks.next(0x02))
                eventX = M.readLengthMultibyte(f);
            if (chunks.next(0x03))
                eventY = M.readLengthMultibyte(f);
            
            M.currentEvent = "Event " + eventNum + " (" + eventX + "," + eventY + ")";
            M.currentEventNum = eventNum;
            
            if (chunks.next(0x05))
                pages = M.readList<Page>(f, "Page"); // Argument makes it set currentPage/currentPageNum before loading each page
            
            M.byteCheck(f, 0x00);
        }
        
        // Checks for teleport commands in all pages.
        public void getWarps()
        {
            M.currentEventNum = eventNum;
            M.currentEvent = eventNum.ToString();
            
            for (int i = 0; i < pages.Count; i++)
                pages[i].getWarps();
        }
        
        // Writes event data, to parent writer by default, and returns the byte size of that data.
        override protected void myWrite()
        {
            M.writeMultibyte(eventNum);
            
            if (chunks.wasNext(0x01))
                M.writeString(eventName, M.S_UNTRANSLATED);
            
            if (chunks.wasNext(0x02))
                M.writeLengthMultibyte(eventX);
            if (chunks.wasNext(0x03))
                M.writeLengthMultibyte(eventY);
                
            if (chunks.wasNext(0x05))
                M.writeList<Page>(pages);
            
            M.writeByte(0x00);
        }
        
        // Returns Page of given number.
        public Page getPage(int num)
        {
            for (int i = 0; i < pages.Count; i++)
            {
                if (pages[i].pageNum == num)
                    return pages[i];
            }
            
            Console.WriteLine("Warning: Page to edit not found!");
            return null;
        }
        
        // Returns number of pages.
        public int getPageCount()
        {
            return pages.Count;
        }
        
        // Adds a blank page to the end.
        public void addPage()
        {
            int num = pages.Count + 1;
            pages.Add(new Page(num));
        }
        
        // Adds the given page.
        public void addPage(Page page)
        {
            pages.Add(page);
        }
        
        // Removes a page.
        public void removePage(int num)
        {
            pages.RemoveAt(num - 1);
        }
        
        // Sets X and Y position, and ensures chunks for them are added.
        public void setPosition(int x, int y)
        {
            eventX = x;
            eventY = y;
            
            chunks.add(0x02);
            chunks.add(0x03);
        }
    }
}
